package ru.yandex.solomon.tool.stockpile.backup;

import java.util.List;

import ru.yandex.kikimr.client.kv.KikimrKvClient;
import ru.yandex.stockpile.server.data.names.FileNamePrefix;


/**
 * @author Sergey Polovko
 */
public class BackupWithStats {

    private final FileNamePrefix.Backup backup;
    private final List<KikimrKvClient.KvEntryStats> files;

    public BackupWithStats(FileNamePrefix.Backup backup, List<KikimrKvClient.KvEntryStats> files) {
        this.backup = backup;
        this.files = files;
    }

    public FileNamePrefix.Backup getBackup() {
        return backup;
    }

    public List<KikimrKvClient.KvEntryStats> getFiles() {
        return files;
    }

    public long getFilesSize() {
        return files.stream().mapToLong(KikimrKvClient.KvEntryStats::getSize).sum();
    }

    @Override
    public String toString() {
        return "BackupWithStats{backup=" + backup + ", files=" + files + '}';
    }
}
