package main

func BpfClass(code uint16) uint16 {
	return code & 0x07
}

const (
	BpfLda  uint16 = 0x00
	BpfLdx  uint16 = 0x01
	BpfSta  uint16 = 0x02
	BpfStx  uint16 = 0x03
	BpfAlu  uint16 = 0x04
	BpfJmp  uint16 = 0x05
	BpfRet  uint16 = 0x06
	BpfMisc uint16 = 0x07
)

// ld/ldx fields
func BpfSize(code uint16) uint16 {
	return code & 0x18
}

const (
	BpfW uint16 = 0x00
	BpfH uint16 = 0x08
	BpfB uint16 = 0x10
)

func BpfMode(code uint16) uint16 {
	return code & 0xe0
}

const (
	BpfImm uint16 = 0x00
	BpfAbs uint16 = 0x20
	BpfInd uint16 = 0x40
	BpfMem uint16 = 0x60
	BpfLen uint16 = 0x80
	BpfMsh uint16 = 0xa0
)

func BpfOp(code uint16) uint16 {
	return code & 0xf0
}

const (
	BpfAdd uint16 = 0x00
	BpfSub uint16 = 0x10
	BpfMul uint16 = 0x20
	BpfDiv uint16 = 0x30
	BpfOr  uint16 = 0x40
	BpfAnd uint16 = 0x50
	BpfLsh uint16 = 0x60
	BpfRsh uint16 = 0x70
	BpfNeg uint16 = 0x80
	BpfMod uint16 = 0x90
	BpfXor uint16 = 0xa0

	BpfJa   uint16 = 0x00
	BpfJeq  uint16 = 0x10
	BpfJgt  uint16 = 0x20
	BpfJge  uint16 = 0x30
	BpfJset uint16 = 0x40
)

func BpfSrc(code uint16) uint16 {
	return code & 0x08
}

const (
	BpfK uint16 = 0x00
	BpfX uint16 = 0x08
)

// BpfK and BpfX also apply
func BpfRval(code uint16) uint16 {
	return code & 0x18
}

const (
	BpfA uint16 = 0x10
)

func BpfMiscop(code uint16) uint16 {
	return code & 0xf8
}

const (
	BpfTax uint16 = 0x00
	BpfTxa uint16 = 0x80
)
