package cmd

import (
	"a.yandex-team.ru/solomon/tools/release/cmd/recipe"
	"github.com/spf13/cobra"
)

func init() {
	recipeCmd := &cobra.Command{
		Use:                   "recipe",
		Short:                 "Run release recipe for particular service and environment",
		DisableFlagParsing:    true,
		DisableFlagsInUseLine: true,
		RunE:                  runRecipeCmd,
	}
	recipeCmd.AddCommand(recipe.AlertingCmd)
	recipeCmd.AddCommand(recipe.CoremonCmd)
	recipeCmd.AddCommand(recipe.FetcherCmd)
	recipeCmd.AddCommand(recipe.GatewayCmd)
	recipeCmd.AddCommand(recipe.StockpileCmd)
	recipeCmd.AddCommand(recipe.BackupCmd)
	recipeCmd.AddCommand(recipe.DataproxyCmd)
	recipeCmd.AddCommand(recipe.NameResolverCmd)
	recipeCmd.AddCommand(recipe.ProjectManagerCmd)
	rootCmd.AddCommand(recipeCmd)
}

func runRecipeCmd(cmd *cobra.Command, args []string) error {
	return cmd.Usage()
}
