package cli

import (
	"a.yandex-team.ru/solomon/libs/go/color"
	"bufio"
	"log"
	"os"
	"strings"
)

func Confirm(fmt string, v ...interface{}) bool {
	log.Printf(fmt, v...)

	reader := bufio.NewReader(os.Stdin)
	for {
		response, err := reader.ReadString('\n')
		if err != nil {
			log.Fatalf("cannot read from stdin: %v", err)
		}

		switch strings.ToLower(strings.TrimSpace(response)) {
		case "yes":
			return true
		case "no":
			return false
		}
	}
}

func CanContinueUpdate(failedCount int) bool {
	if failedCount > 0 {
		if !Confirm(color.Red("Some nodes (%d) failed to update. Continue update? [yes/No]"), failedCount) {
			return false
		}
	}
	return true
}
