package hosts

import (
	hostsPB "a.yandex-team.ru/solomon/tools/release/internal/hosts/proto"
	"time"
)

func ParseMutes(pbMutes *hostsPB.MuteList) (*MuteList, error) {
	if pbMutes == nil {
		return nil, nil
	}
	return &MuteList{
		ProjectID: pbMutes.ProjectId,
		Alerts:    parseAlerts(pbMutes.Alerts),
	}, nil
}

func parseAlerts(pbAlerts []*hostsPB.Alert) []Alert {
	alerts := make([]Alert, 0, len(pbAlerts))

	for _, pbAlert := range pbAlerts {
		alerts = append(alerts, Alert{
			ID:             pbAlert.Id,
			LabelSelectors: pbAlert.LabelSelectors,
			CoolDown:       time.Duration(pbAlert.CooldownMinutes) * time.Minute,
			ProjectID:      pbAlert.ProjectId,
		})
	}

	return alerts
}
