package hosts

import "strings"

type Env int

const (
	EnvUnknown Env = iota
	EnvTest
	EnvPre
	EnvProd
	EnvCloudPre
	EnvCloudProd
	EnvCloudGpn
)

var EnvNames = []string{
	"unknown",
	"test",
	"pre",
	"prod",
	"cloud_pre",
	"cloud_prod",
	"cloud_gpn",
}

func (e Env) String() string {
	return EnvNames[e]
}

func (e Env) IsCloud() bool {
	return e == EnvCloudPre || e == EnvCloudProd || e == EnvCloudGpn
}

func (e Env) IsGpn() bool {
	return e == EnvCloudGpn
}

func EnvFromStr(str string) Env {
	switch strings.ToLower(str) {
	case "test":
		return EnvTest
	case "pre":
		return EnvPre
	case "prod":
		return EnvProd
	case "cloud_pre", "cloudpre":
		return EnvCloudPre
	case "cloud_prod", "cloudprod":
		return EnvCloudProd
	case "cloud_gpn", "cloudgpn":
		return EnvCloudGpn
	default:
		return EnvUnknown
	}
}
