package hosts

import (
	hostsCommon "a.yandex-team.ru/solomon/libs/go/hosts"
	"fmt"
	"log"
	"net"
	"strings"
)

func ResolveAddress(hostname string) (*hostsCommon.Address, error) {
	ips, err := net.LookupIP(hostname)
	if err != nil {
		return nil, fmt.Errorf("cannot resolve hostname %s: %v", hostname, err)
	}

	if len(ips) > 1 {
		return nil, fmt.Errorf("hostname %s has multiple ips: %v", hostname, ips)
	}

	return &hostsCommon.Address{Name: hostname, IP: ips[0]}, nil
}

func ResolveAddresses(hostnames []string) ([]hostsCommon.Address, error) {
	log.Printf("resolve %d IP addresses", len(hostnames))

	hosts := make([]hostsCommon.Address, 0, len(hostnames))
	for _, hostname := range hostnames {
		ips, err := net.LookupIP(hostname)
		if err != nil {
			log.Printf("cannot resolve hostname %s: %v", hostname, err)
			continue
		}

		if len(ips) > 1 {
			return nil, fmt.Errorf("hostname %s has multiple ips: %v", hostname, ips)
		}

		if strings.Contains(hostname, "-man-") {
			log.Printf("skipped host %s, there is no MAN anymore", hostname)
			continue
		}
		hosts = append(hosts, hostsCommon.Address{Name: hostname, IP: ips[0]})
	}
	return hosts, nil
}
