package infra

import "strconv"

type Event struct {
	ID                     int       `json:"id"`
	ServiceID              ServiceID `json:"serviceId"`
	EnvironmentID          EnvID     `json:"environmentId"`
	Title                  string    `json:"title"`
	Description            string    `json:"description"`
	Type                   string    `json:"type"`
	Severity               string    `json:"severity"`
	StartTime              int64     `json:"startTime"`
	FinishTime             int64     `json:"finishTime"`
	SendEmailNotifications bool      `json:"sendEmailNotifications"`
	Tickets                *string   `json:"tickets,omitempty"`
	Sas                    *bool     `json:"sas,omitempty"`
	Vla                    *bool     `json:"vla,omitempty"`
	Man                    *bool     `json:"man,omitempty"`
	Myt                    *bool     `json:"myt,omitempty"`
	Iva                    *bool     `json:"iva,omitempty"`
	GpnA                   *bool     `json:"gpn_a,omitempty"`
	GpnB                   *bool     `json:"gpn_b,omitempty"`
}

func (e *Event) URL() string {
	return "https://infra.yandex-team.ru/event/" + strconv.Itoa(e.ID)
}
