package mutes

import (
	"fmt"
)

type SelectorsMute struct {
	AlertSelector  string `json:"alertSelector"`
	LabelSelectors string `json:"labelSelectors"`
}

type MuteType struct {
	Selectors *SelectorsMute `json:"selectors"`
}

type Mute struct {
	ID          *string  `json:"id"`
	ProjectID   string   `json:"projectId"`
	Description string   `json:"description"`
	Name        string   `json:"name"`
	TicketID    string   `json:"ticketId"`
	From        *string  `json:"from"`
	To          string   `json:"to"`
	Type        MuteType `json:"type"`
	CreatedAt   *string  `json:"createdAt"`
	CreatedBy   *string  `json:"createdBy"`
	UpdatedAt   *string  `json:"updatedAt"`
	UpdatedBy   *string  `json:"updatedBy"`
	Version     *int32   `json:"version"`
}

func (mute *Mute) URL() string {
	return fmt.Sprintf("https://solomon.yandex-team.ru/admin/projects/%s/mutes/%s", mute.ProjectID, *mute.ID)
}
