package oauth

import (
	"context"
	"fmt"
	"os"

	"a.yandex-team.ru/library/go/yandex/oauth"
)

// solomon-ops application https://oauth.yandex-team.ru/client/350dd730a52a4a018323255d235889f5
const (
	clientID     = "350dd730a52a4a018323255d235889f5"
	clientSecret = "0dd1e4d7b381494180255114e2faa990"
	tokenVarName = "OAUTH_TOKEN"
)

func GetMyToken(ctx context.Context) (string, error) {
	if value, ok := os.LookupEnv(tokenVarName); ok && value != "" {
		return value, nil
	}

	token, err := GetMyTokenBySSH(ctx)
	return token, err
}

func GetMyTokenBySSH(ctx context.Context) (string, error) {
	token, err := oauth.GetTokenBySSH(ctx, clientID, clientSecret)
	if err != nil {
		return "", fmt.Errorf("cannot get OAuth token by SSH: %v", err)
	}
	return token, nil
}
