package staffonly

import (
	"a.yandex-team.ru/solomon/libs/go/uhttp"
	"a.yandex-team.ru/solomon/tools/release/internal/hosts"
	"context"
	"fmt"
	"log"
	"net/http"
	"time"
)

var gateways = map[hosts.Env]string{
	hosts.EnvTest:      "solomon-test.yandex-team.ru",
	hosts.EnvPre:       "solomon-pre.yandex-team.ru",
	hosts.EnvProd:      "solomon.yandex-team.ru",
	hosts.EnvCloudPre:  "solomon.cloud-preprod.yandex-team.ru",
	hosts.EnvCloudProd: "solomon.cloud.yandex-team.ru",
	hosts.EnvCloudGpn:  "solomon.ycp.gpn.yandexcloud.net",
}

type Client struct {
	httpClient *uhttp.Client
	port       int
}

func NewClient(env hosts.Env, token string, port int, followRedirects bool) *Client {
	gateway, ok := gateways[env]
	if !ok {
		log.Fatalf("unknown staff only gateway environment: %v", env)
	}

	baseURL := fmt.Sprintf("https://%s/staffOnly", gateway)
	return &Client{
		httpClient: uhttp.NewClient(baseURL, "solomon-release-tool", uhttp.OAuthToken(token), time.Second*3, followRedirects),
		port:       port,
	}
}

func (c *Client) Get(ctx context.Context, hostname, url string) (*http.Response, error) {
	req, err := c.httpClient.NewGetRequest(ctx, fmt.Sprintf("/%s:%d%s", hostname, c.port, url))
	if err != nil {
		return nil, err
	}
	return c.httpClient.SendRawRequest(req)
}
