package z2

import (
	"a.yandex-team.ru/library/go/yandex/yav/httpyav"
	"context"
	"fmt"
)

type APIKeys map[string]string

// see secret content here https://yav.yandex-team.ru/secret/sec-01fd9qgnrz5emg60n0n5n6fh6m
var apiKeysSecretID = "sec-01fd9qgnrz5emg60n0n5n6fh6m"

func LoadAPIKeys(ctx context.Context, token string) (APIKeys, error) {
	client, err := httpyav.NewClient(httpyav.WithOAuthToken(token))
	if err != nil {
		return nil, fmt.Errorf("cannot initialize yav client, %w", err)
	}

	ver, err := client.GetVersion(ctx, apiKeysSecretID)
	if err != nil {
		return nil, fmt.Errorf("cannot load sercret %s, %w", apiKeysSecretID, err)
	}

	err = ver.Err()
	if err != nil {
		return nil, fmt.Errorf("cannot load sercret %s, %w", apiKeysSecretID, err)
	}

	apiKeys := make(APIKeys)
	for _, value := range ver.Version.Values {
		apiKeys[value.Key] = value.Value
	}
	return apiKeys, nil
}
