package z2

import (
	"a.yandex-team.ru/solomon/libs/go/color"
	"fmt"
)

type UpdateStatus struct {
	UpdateStatus  string   `json:"updateStatus"`
	Result        string   `json:"result"`
	FailedWorkers []string `json:"failedWorkers"`
}

func (s *UpdateStatus) IsFinished() bool {
	// see https://bb.yandex-team.ru/projects/Z2/repos/z2/browse/z2-master/src/main/java/ru/yandex/z2/master/http/ApiServlet.java#146
	return s.UpdateStatus == "FINISHED"
}

func (s *UpdateStatus) Print(configID string) {
	// see https://bb.yandex-team.ru/projects/Z2/repos/z2/browse/z2-master/src/main/java/ru/yandex/z2/master/http/ApiServlet.java#151
	if s.Result == "SUCCESS" {
		fmt.Printf(color.Green("Config %s successfully updated\n"), configID)
	} else {
		fmt.Printf(color.Red("Config %s update failed\n"), configID)
		if len(s.FailedWorkers) != 0 {
			fmt.Println("Failed on next workers:")
			for _, worker := range s.FailedWorkers {
				fmt.Printf("    %s\n", worker)
			}
		}
	}
}

type Workers struct {
	Workers []string `json:"workers"`
}
