package cmd

import (
	"context"
	"fmt"
	"github.com/spf13/cobra"
)

var (
	key string
)

func init() {
	createCmd := &cobra.Command{
		Use:   "get-key",
		Short: "Get secret from yav.yandex-team.ru by key",
		RunE:  runGetKeyCmd,
	}
	createCmd.Flags().StringVar(&key, "key", "", "yav key in format yav://id/key")
	_ = createCmd.MarkFlagRequired("key")
	rootCmd.AddCommand(createCmd)
}

func runGetKeyCmd(cmd *cobra.Command, args []string) error {
	parsedKey := parseKey(key)
	if parsedKey == nil {
		return fmt.Errorf("invalid key format, %s", key)
	}

	secretsMap, err := loadSecrets(context.Background(), []secretRef{*parsedKey})
	if err != nil {
		return err
	}

	_, err = fmt.Print(secretsMap[parsedKey.Format()])
	return err
}
