package client

import (
	"a.yandex-team.ru/solomon/libs/go/uhttp"
	"context"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"time"
)

const (
	pasteURL = "https://paste.yandex-team.ru"
)

type PasteClient struct {
	client *uhttp.Client
}

func NewPasteClient() *PasteClient {
	return &PasteClient{client: uhttp.NewClient(pasteURL, "", nil, 20*time.Second, false)}
}

func (c *PasteClient) Paste(ctx context.Context, text string) (string, error) {
	data := url.Values{}
	data.Set("syntax", "plain")
	data.Add("text", text)

	req, err := c.client.NewPostRequest(ctx, "", []byte(data.Encode()))
	if err != nil {
		return "", fmt.Errorf("cannot create request: %v", err)
	}
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded")
	req.Header.Add("User-Agent", "solomon-service-dashboard-user")

	resp, err := c.client.SendRawRequest(req)
	if err != nil {
		return "", fmt.Errorf("cannot paste: %v", err)
	}
	defer resp.Body.Close()
	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", fmt.Errorf("cannot read response body: %v", err)
	}
	if resp.StatusCode != http.StatusFound {
		return "", fmt.Errorf("errorResponse: %d %s", resp.StatusCode, string(respBody))
	}
	location := resp.Header.Get("Location")
	return pasteURL + location, nil
}
