package client

import (
	"a.yandex-team.ru/solomon/libs/go/color"
	"a.yandex-team.ru/solomon/libs/go/uhttp"
	"context"
	"fmt"
	"log"
	"time"
)

const (
	baseServiceDashboardURL = "/api/internal/serviceDashboards/"
)

type ServiceDashboardClient struct {
	client *uhttp.Client
}

func NewServiceDashboardClient(baseURL, tokenOauth string, tokenIam string) *ServiceDashboardClient {
	var token uhttp.Token
	if tokenIam == "" {
		token = uhttp.OAuthToken(tokenOauth)
	} else {
		token = uhttp.IamToken(tokenIam)
	}
	return &ServiceDashboardClient{client: uhttp.NewClient(baseURL+baseServiceDashboardURL, "", token, 20*time.Second, false)}
}

func (c *ServiceDashboardClient) GetDashboard(ctx context.Context, dashboardID string) (map[string]interface{}, error) {
	req, err := c.client.NewGetRequest(ctx, dashboardID)
	if err != nil {
		return nil, fmt.Errorf("cannot create request: %v", err)
	}

	var data map[string]interface{}
	err = c.client.SendJSONRequest(req, &data)
	if err != nil {
		return nil, fmt.Errorf("cannot get dashboard %s error: %v", dashboardID, err)
	}
	log.Printf("Received dashboard %s", color.Blue(dashboardID))
	return data, nil
}

func (c *ServiceDashboardClient) UpdateDashboard(ctx context.Context, dashboardID string, dashboard string) (string, error) {
	req, err := c.client.NewPutRequest(ctx, dashboardID, []byte(dashboard))
	if err != nil {
		return "", fmt.Errorf("cannot create request: %v", err)
	}
	req.Header.Add("Content-Type", "application/json")

	respBody, err := c.client.SendRequest(req)
	if err != nil {
		return "", fmt.Errorf("cannot update dashboard %s error: %v", dashboardID, err)
	}
	log.Printf("Dashboard %s updated", color.Blue(dashboardID))

	return string(respBody), nil
}
