package utils

import (
	"a.yandex-team.ru/solomon/libs/go/color"
	"bufio"
	"bytes"
	"io/ioutil"
	"log"
	"os"
	"os/exec"
	"strings"
)

const (
	oldFile  = "./old.json"
	newFile  = "./new.json"
	diffFile = "./diff"
)

func PrintDiff(old []byte, new []byte) error {
	err := ioutil.WriteFile(oldFile, old, 0666)
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(newFile, new, 0666)
	if err != nil {
		return err
	}

	diff := exec.Command("diff", oldFile, newFile)
	outfile, err := os.Create(diffFile)
	if err != nil {
		return err
	}
	defer outfile.Close()
	diff.Stdout = outfile
	err = diff.Run()
	if err != nil {
		if exitError, ok := err.(*exec.ExitError); ok {
			// 1 is ok for diff
			if exitError.ExitCode() != 1 {
				return err
			}
		}
	}

	file, err := os.Open(diffFile)
	if err != nil {
		return err
	}
	defer file.Close()

	containDiff := false
	var buffer bytes.Buffer
	buffer.WriteString("Dashboard diff:\n")
	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		line := scanner.Text()
		containDiff = true
		if strings.HasPrefix(line, "<") {
			buffer.WriteString(color.Red(line))
		} else if strings.HasPrefix(line, ">") {
			buffer.WriteString(color.Green(line))
		} else {
			buffer.WriteString(line)
		}
		buffer.WriteString("\n")
	}
	if !containDiff {
		buffer.WriteString(color.Green("Files are equal\n"))
	}
	log.Println(buffer.String())
	return scanner.Err()
}
