#!/bin/bash -e

if [ $# -eq 0 ]; then
    echo "Usage: $0 {conductor_group} {trace_dir} {files_mask}" >&2
    exit 1
fi

HOSTS=$(curl http://c.yandex-team.ru/api/groups2hosts/${1})
TRACE_DIR=${2:-"trace"}
FILE_MASK=${3:-"ingestor_trace.log.1"}

echo "${FILE_MASK}"

mkdir -p "${TRACE_DIR}"
for h in $HOSTS; do
    short_name=$(echo "${h}" | cut -d"." -f1)
    folder="${TRACE_DIR}/${short_name}"
    mkdir -p "${folder}"
    scp "${h}:/Berkanavt/solomon/logs/${FILE_MASK}" "${folder}/" &
done
wait
gunzip -qr trace
