package main

import (
	"github.com/golang/protobuf/proto"
	"github.com/yandex/pandora/core"
)

type ProtoAmmo struct {
	Pull       bool          `json:"pull"`
	RawMessage string        `json:"req"`
	Message    proto.Message `json:"-"`
}

func (a ProtoAmmo) Tag() string {
	if a.Pull {
		return "pull"
	}
	return "push"
}

func NewAmmo() core.Ammo {
	return &ProtoAmmo{}
}
