package main

import (
	ingestor "a.yandex-team.ru/solomon/services/ingestor/api"
	"encoding/base64"
	"github.com/golang/protobuf/proto"
	"github.com/yandex/pandora/core"
	"github.com/yandex/pandora/core/provider"
)

type protoAmmoDecoder struct {
	source provider.AmmoDecoder
}

func decodeProto(ammo *ProtoAmmo) error {
	bytes, err := base64.StdEncoding.DecodeString(ammo.RawMessage)
	if err != nil {
		return err
	}

	if ammo.Pull {
		ammo.Message = &ingestor.TPulledDataRequest{}
	} else {
		ammo.Message = &ingestor.TPushedDataRequest{}
	}

	ammo.RawMessage = "" // free memory
	return proto.UnmarshalMerge(bytes, ammo.Message)
}

func (d protoAmmoDecoder) Decode(ammo core.Ammo) error {
	err := d.source.Decode(ammo)
	if err != nil {
		return err
	}
	return decodeProto(ammo.(*ProtoAmmo))
}

func NewProtoAmmoDecoder(_ core.ProviderDeps, decoder provider.AmmoDecoder) provider.AmmoDecoder {
	return WrapToProtoAmmoDecoder(decoder)
}

func WrapToProtoAmmoDecoder(decoder provider.AmmoDecoder) provider.AmmoDecoder {
	return protoAmmoDecoder{decoder}
}

func NewAmmoProvider(conf provider.JSONProviderConfig) core.Provider {
	return provider.NewCustomJSONProvider(NewProtoAmmoDecoder, NewAmmo, conf)
}
