package main

import (
	"io/ioutil"
	"net/http"
	"strings"
)

func resolveHosts(conductorGroup string) ([]string, error) {
	resp, err := http.Get("https://c.yandex-team.ru/api/groups2hosts/" + conductorGroup)
	if err != nil {
		return nil, err
	}

	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	splitFn := func(c rune) bool {
		return c == '\n'
	}
	return strings.FieldsFunc(string(body), splitFn), nil
	//return strings.Split(string(body), "\n"), nil
}
