package main

import "strings"

var ConductorPrefix = "conductor_group://"

func ResolveTarget(target string) ([]string, string, error) {
	if strings.HasPrefix(target, ConductorPrefix) {
		target = strings.TrimPrefix(target, ConductorPrefix)
		return resolveConductorTarget(strings.TrimPrefix(target, ConductorPrefix))
	}

	host, port := splitHostPort(target)
	hosts := []string{host}
	return hosts, port, nil
}

func resolveConductorTarget(target string) ([]string, string, error) {
	conductorGroup, port := splitHostPort(target)
	hosts, err := resolveHosts(conductorGroup)
	return hosts, port, err
}

func splitHostPort(hostPort string) (host, port string) {
	colon := strings.LastIndexByte(hostPort, ':')
	return hostPort[:colon], hostPort[colon+1:]
}
