#!/bin/bash -e


if [ $# -ge 2 ]; then
    echo "Usage: $0 {traceDir} {ammoDir}" >&2
    exit 1
fi

TRACE_DIR=${1:-"trace"}
AMMO_DIR=${2:-"ammo"}

mkdir -p "${TRACE_DIR}"
mkdir -p "${AMMO_DIR}"

# gen_ammo <folder>
gen_ammo() {
    folder=${1}
    prefix=$(basename "${folder}" | cut -d"." -f1)
    target="${AMMO_DIR}/${prefix}-ammo.json"
    ./ammo-gen/ammo-gen -source "${folder}" -target "${target}"
    cat "${target}" >> "${AMMO_DIR}/cluster-ammo.json"
    echo "Generated ammo for ${folder}"
}

for path in "${TRACE_DIR}"/*
do
  gen_ammo "${path}"
done

cat "${AMMO_DIR}/cluster-ammo.json" | shuf -o "${AMMO_DIR}/cluster-shuffled-ammo.json"
