package main

import (
	"log"
	"strings"
)

func (c *SolomonClient) GetMenu(instance *Instance) (map[string]interface{}, error) {
	body, err := c.GetOptional(instance, "/api/v2/projects/"+instance.ProjectID+"/menu")
	if err != nil {
		return nil, err
	}
	if body == nil {
		return nil, nil
	}
	return deserialize(body)
}

func (c *SolomonClient) CreateMenu(instance *Instance, model map[string]interface{}) error {
	endpoint := "/api/v2/projects/" + instance.ProjectID + "/menu"
	body, err := serialize(model)
	if err != nil {
		return err
	}
	return c.Post(instance, endpoint, body)
}

func (c *SolomonClient) UpdateMenu(instance *Instance, model map[string]interface{}) error {
	endpoint := "/api/v2/projects/" + instance.ProjectID + "/menu"
	body, err := serialize(model)
	if err != nil {
		return err
	}
	return c.Put(instance, endpoint, body)
}

func (c *SolomonClient) SyncMenu(p Plan) {
	entity, err := c.GetMenu(ProdMainSolomon)
	if err != nil {
		log.Println("Failed to GetMenu: " + err.Error())
		return
	}
	if entity != nil {
		p.SyncInstances(func(instance *Instance) {
			c.syncMenu(instance, entity)
		})
	} else {
		log.Println(ProdMainSolomon.Name + " Menu not exists")
	}
}

func (c *SolomonClient) syncMenu(instance *Instance, source map[string]interface{}) {
	patched := patchMenu(instance, source)
	target, err := c.GetMenu(instance)
	if err != nil {
		log.Println(instance.Name + " Menu FAILED: " + err.Error())
		return
	}
	if target == nil {
		if err = c.CreateMenu(instance, patched); err == nil {
			log.Println(instance.Name + " Menu CREATED")
		} else {
			log.Println(instance.Name + " Menu FAILED: " + err.Error())
		}
	} else {
		RemoveCommonAttributes(target)
		CopyVersion(target, patched)
		if isEqualLogDiff(instance, "menu", patched, target) {
			log.Println(instance.Name + " Menu SKIP already sync")
		} else {
			if err = c.UpdateMenu(instance, patched); err == nil {
				log.Println(instance.Name + " Menu UPDATED")
			} else {
				log.Println(instance.Name + " Menu FAILED: " + err.Error())
			}
		}
	}
}

func isControlPlaneLink(s string) bool {
	return strings.Contains(s, "/admin/projects/{{projectId}}") ||
		strings.Contains(s, "/staffOnly")
}

func patchMenu(instance *Instance, source map[string]interface{}) map[string]interface{} {
	patched := applyMap(source, "", func(path string, s string) string {
		if s == "solomon" {
			return instance.ProjectID
		}
		patchedStr := s
		patchedStr = ApplyAllRules(instance, patchedStr)
		patchedStr = strings.ReplaceAll(patchedStr, "Prestable", instance.Pre)
		patchedStr = PathReference(instance, patchedStr)
		if isControlPlaneLink(patchedStr) {
			patchedStr = strings.ReplaceAll(patchedStr, ProdMainSolomon.Admin, instance.Admin)
			patchedStr = strings.ReplaceAll(patchedStr, ProdMainSolomon.AdminPre, instance.AdminPre)
		}
		return patchedStr
	})
	RemoveCommonAttributes(patched)
	return patched
}
