#include <iostream>
#include <stdlib.h>

#include "arguments.h"

TArguments::TArguments(std::string Help) {
     GeneralHelp = Help;
}

TArguments::~TArguments() {}

void TArguments::AddKey(std::string Key, ArgStatus Status, std::string Description) {
    ArgumentsMap[Key.c_str()[0]] = {false, 0, "", 0, Status, Description};
}

TArguments::KeyStatus TArguments::GetKey(std::string Key) {
    return ArgumentsMap[Key[0]];
}

void TArguments::Parse(int argc, char* argv[]) {
    std::string Serr;
    MyName = argv[0];
    for (int i = 1; i < argc; ++i) {
        char *arg = argv[i];
        if (arg[0] == '-') {
            while (*(++arg) != 0) {
                auto it = ArgumentsMap.find(*arg);
                if (it != ArgumentsMap.end()) {
                    it->second.isPresent = true;
                    it->second.Count++;
                    if (it->second.Status == intarg) {
                        if (*(arg + 1) != 0 || ++i >= argc) {
                            Serr = "No argument for key -";
                            Serr.push_back(*arg);
                            Usage(Serr);
                        }
                        it->second.StrValue = argv[i];
                        try {
                            it->second.IntValue = std::stoi(it->second.StrValue);
                        }
                        catch (std::invalid_argument) {
                            Usage("Wrong integer argument " + it->second.StrValue);
                        }
                        break;
                    }
                    else if (it->second.Status == strarg) {
                        if (*(arg + 1) != 0 || ++i >= argc) {
                            Serr = "No argument for key -";
                            Serr.push_back(*arg);
                            Usage(Serr);
                        }
                        it->second.StrValue = argv[i];
                        break;
                    }
                }
                else if (*arg == 'h') {
                    Usage();
                }
                else {
                    Serr = "Unknown argument '";
                    Serr += *arg;
                    Usage(Serr + "'");
                }
            }
        }
        else {
            Serr = "Unknown argument '";
            Serr += *arg;
            Usage(Serr + "'");
        }
    }
}

void TArguments::Usage(std::string WhichError) {
    if (WhichError.size() > 0)
        std::cerr << WhichError << std::endl;
    std::cerr << "Usage: " << MyName << " " << GeneralHelp << "\n"
              << "Options:";
    for (auto it = ArgumentsMap.begin(); it != ArgumentsMap.end(); ++it)
        std::cerr << "\n\t-" << it->first << ((it->second.Status != noarg) ? " <arg>\t" : "\t\t") << "- " << it->second.Description;
    std::cerr << std::endl;
    exit(EXIT_FAILURE);
}

