#pragma once

#ifndef _ARGUMENTS_H_
#define _ARGUMENTS_H_

#include <string>
#include <unordered_map>

class TArguments {
public:
    enum ArgStatus { intarg, strarg, noarg };
    struct KeyStatus {
        bool        isPresent;
        uint16_t    Count;
        std::string StrValue;
        int         IntValue;
        ArgStatus   Status;
        std::string Description;
    };
public:
    TArguments(std::string);
    ~TArguments();

    void AddKey(std::string, ArgStatus, std::string);
    KeyStatus GetKey(std::string);
    void Parse(int, char**);
    void Usage(std::string = "");
private:
    std::unordered_map<char, KeyStatus> ArgumentsMap;
    std::string MyName;
    std::string GeneralHelp;
};

#endif
