#pragma once

#include <unistd.h>
#include <string.h>
#include <string>

#ifndef _TBUFFER_H_
#define _TBUFFER_H_


class TMyBuffer {
public:
    TMyBuffer();
    TMyBuffer(const char *);
    ~TMyBuffer();

    size_t size();
    char *data();
    void resize(size_t);
    void zresize(size_t);
    void append(const char *, size_t);
    void append(size_t, char);
    void zappend(size_t);
    void clear();
    void erase(size_t, size_t);
    void *begin();
    void *end();
    char &front();
    char &back();
    char *substr(size_t, size_t);
    size_t hash();
    size_t subhash(size_t, size_t) const;

    char &operator[](size_t);
    const char &operator[](size_t) const;

    TMyBuffer(const TMyBuffer &);
    TMyBuffer& operator=(const TMyBuffer &);
    TMyBuffer& operator=(const std::string &);
    TMyBuffer& operator=(const char *);

    TMyBuffer(TMyBuffer &&);
    TMyBuffer& operator=(TMyBuffer &&) noexcept;

    TMyBuffer& operator+=(const TMyBuffer &);
    TMyBuffer& operator+=(const std::string &);
    TMyBuffer& operator+=(const char *);
    friend TMyBuffer operator+(TMyBuffer, const TMyBuffer &);
    friend TMyBuffer operator+(TMyBuffer, const std::string &);
    friend TMyBuffer operator+(TMyBuffer, const char *);
    friend bool operator<(const TMyBuffer &, const TMyBuffer &);
    friend bool operator==(const TMyBuffer &, const TMyBuffer &);
    friend inline bool operator!=(const TMyBuffer &, const TMyBuffer &);
    friend inline bool operator> (const TMyBuffer &, const TMyBuffer &);
    friend inline bool operator<=(const TMyBuffer &, const TMyBuffer &);
    friend inline bool operator>=(const TMyBuffer &, const TMyBuffer &);
private:
    void  *Container     = nullptr;
    size_t ContainerSize = 0;
    size_t DataSize      = 0;
};

#endif
