#pragma once

#ifndef _CLASSIP_H_
#define _CLASSIP_H_

#include <string>
#include <unistd.h>
#include <netinet/ip6.h>

class TIP {
public:
    TIP() {}
    TIP(std::string, uint16_t);
    void ConstructFromNamePort(std::string, uint16_t);
    TIP(std::string);
    void ConstructFromHostPort(std::string);
    TIP(uint32_t, uint16_t);
    void ConstructFromAddrPort(uint32_t, uint16_t);
    TIP(uint8_t *, uint16_t);
    void ConstructFromAddr6Port(uint8_t *, uint16_t);
    TIP(struct sockaddr *);
    void ConstructFromSockaddr(struct sockaddr *);
    TIP(struct sockaddr_in *);
    void ConstructFromSockaddrIn(struct sockaddr_in *);
    TIP(struct sockaddr_in6 *);
    void ConstructFromSockaddr6In(struct sockaddr_in6 *);

    ~TIP() {}

    const char *GetIPChar() const;
    const std::string GetName();
    const struct sockaddr_in *GetSockAddr() const;
    const struct sockaddr_in6 *GetSockAddr6() const;
    uint16_t GetPort() const;
    int GetFamily() const;

    size_t hash() const;

    TIP &operator=(const TIP &);
    friend bool operator<(const TIP &, const TIP &);
    friend bool operator==(const TIP &, const TIP &);

private:
    char IPChar[INET6_ADDRSTRLEN + 1];
    std::string Name = "";
    uint16_t Port = 0;
    uint32_t Address = 0;
    uint8_t Address6[16] = {0};
    int Family = 0;
    struct sockaddr_in SockAddress;
    struct sockaddr_in6 SockAddress6;
};
namespace std {
    template <>
    struct hash<TIP> {
        std::size_t operator()(const TIP &a) const {
            return a.hash();
        }
    };
}

#endif
