#pragma once

#ifndef _CLASSTIME_H_
#define _CLASSTIME_H_

#include <sys/time.h>
#include <time.h>
#include <iostream>

class Time {
public:
    struct timeval TimeValue = {0, 0};
    int64_t uSec = 0;

    Time() {
        Update();
    }
    Time(int64_t Int) {
        uSec = Int*1000000;
        FormatFromUsec();
    }
    Time(struct timeval Tv) {
        TimeValue.tv_sec = Tv.tv_sec;
        TimeValue.tv_usec = Tv.tv_usec;
        uSec = TimeValue.tv_sec*1000000 + TimeValue.tv_usec;
    }
    ~Time() {
    }
    void Update() {
        gettimeofday(&TimeValue, NULL);
        uSec = TimeValue.tv_sec*1000000 + TimeValue.tv_usec;
    }
    int64_t Sec() {
        return uSec/1000000;
    }
    void FormatFromUsec() {
        TimeValue.tv_usec = uSec/1000000;
        TimeValue.tv_sec = uSec - TimeValue.tv_sec*1000000;
    }

    friend std::ostream& operator<<(std::ostream& os, const Time& obj) {
        char str[32];
        snprintf(str, 18, "%.6f", obj.uSec/1000000.0);
        os << str;
        return os;
    }
    Time& operator=(const Time &r) {
        this->TimeValue.tv_sec = r.TimeValue.tv_sec;
        this->TimeValue.tv_usec = r.TimeValue.tv_usec;
        this->uSec = r.uSec;
        return *this;
    }

    Time& operator+=(const Time &r) { this->uSec += r.uSec; this->FormatFromUsec(); return *this; }
    template<typename T>
    Time& operator+=(const T &r) { this->uSec += r*1000000; this->FormatFromUsec(); return *this; }

    Time& operator-=(const Time &r) { this->uSec -= r.uSec; this->FormatFromUsec(); return *this; }
    template<typename T>
    Time& operator-=(const T &r) { this->uSec -= r*1000000; this->FormatFromUsec(); return *this; }

    friend Time operator+ (Time l, const Time &r) { l += r; return l; }
    friend Time operator- (Time l, const Time &r) { l -= r; return l; }
    template<typename T>
    friend Time operator+ (Time l, const T &r) { l.uSec += r*1000000; l.FormatFromUsec(); return l; }
    template<typename T>
    friend Time operator- (Time l, const T &r) { l.uSec -= r*1000000; l.FormatFromUsec(); return l; }

    friend bool operator< (const Time &l, const Time &r) { return l.uSec <  r.uSec; }
    friend bool operator==(const Time &l, const Time &r) { return l.uSec == r.uSec; }
    friend bool operator> (const Time &l, const Time &r) { return l.uSec >  r.uSec; }
    friend bool operator<=(const Time &l, const Time &r) { return !(l > r); }
    friend bool operator>=(const Time &l, const Time &r) { return !(l < r); }
};

#endif
