#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/epoll.h>

#include "epoll.h"
#include "log.h"

TEpoll::TEpoll() {
    if ((EpollFD = epoll_create(MAX_EPOLL_EVENTS)) < 0)
        Fatal("epoll create error");
}

TEpoll::~TEpoll() {
    close(EpollFD);
}

void TEpoll::Add(int fd, int events) {
    struct epoll_event EpollEvent;
    memset(&EpollEvent, 0, sizeof(epoll_event));

    EpollEvent.events = events;
    EpollEvent.data.fd = fd;
    if (epoll_ctl(EpollFD, EPOLL_CTL_ADD, fd, &EpollEvent) < 0)
        Fatal("epoll failed on ADD, %i: %s", errno, strerror(errno));
}

void TEpoll::Mod(int fd, int events) {
    struct epoll_event EpollEvent;
    memset(&EpollEvent, 0, sizeof(epoll_event));

    EpollEvent.events = events;
    EpollEvent.data.fd = fd;
    if (epoll_ctl(EpollFD, EPOLL_CTL_MOD, fd, &EpollEvent) < 0)
        Fatal("epoll failed on MOD, %i: %s", errno, strerror(errno));
}

void TEpoll::Del(int fd) {
    struct epoll_event EpollEvent;
    memset(&EpollEvent, 0, sizeof(epoll_event));

    EpollEvent.data.fd = fd;
    if (epoll_ctl(EpollFD, EPOLL_CTL_DEL, fd, &EpollEvent) < 0)
        Fatal("epoll failed on DEL, %i: %s", errno, strerror(errno));
}

void TEpoll::Wait(int Timeout) {
    if ((EpollFDNumber = epoll_wait(EpollFD, EpollEventsArray, MAX_EPOLL_EVENTS, Timeout)) < 0) {
        if (errno == EINTR) {
            Log("epoll interrupted");
            exit(EXIT_SUCCESS);
        }
        Fatal("epoll wait error");
    }
}

struct epoll_event *TEpoll::begin() {
    return EpollEventsArray;
}

struct epoll_event *TEpoll::end() {
    return EpollEventsArray + EpollFDNumber;
}
