#pragma once

#ifndef _LOG_H_
#define _LOG_H_

#include <stdio.h>

#define PRINTF_MSGLEN 1024

static char fmsg[PRINTF_MSGLEN];

void _Log(const char *);

#define Log(...)   do { snprintf(fmsg, PRINTF_MSGLEN, __VA_ARGS__); _Log(fmsg); } while (0)
#define Fatal(...) do { snprintf(fmsg, PRINTF_MSGLEN, __VA_ARGS__); _Log(fmsg); exit(EXIT_FAILURE); } while (0)

#endif
