#pragma once

#ifndef _NET_H_
#define _NET_H_

#include "buffer.h"
#include "classip.h"
#include "classtime.h"
#include <memory>

#define DEFAULTBUFFERLENGTH 8192
#define DEBUG false

class TNet {
    /*
     * Servers:
     *
     * TNet TCPServer(TIP);
     * TCPServer.ListenTCP(); unique_ptr<TNet> TCPClient = TCPServer.AcceptTCP(); TCPClient->RecvTCP();
     *
     * TNet UDPServer(TIP);
     * UDPServer.ListenUDP(); unique_ptr<TNet> UDPClient = UDPServer.RecvUDP();
     *
     * Clients:
     *
     * TNet TCPClient(TIP);
     * TCPClient.OutputBuffer("Buffer"); TCPClient.ConnectTCP(); TCPClient.SendTCP();
     *
     * TNet UDPClient(TIP);
     * UDPClient.CreateUDP(); [TNet UDPClientSource(TIP_src); UDPClientSource.ListenUDP(); UDPClient.SocketUDP = UDPClientSource.SocketUDP;]
     * UDPClient.SendUDP();
     */

public:
    TNet() {}
    TNet(TIP);
    ~TNet();

    void Down();
    void SetSocketOwner();
    void ResetSocketOwner();
    int GetTCPSocket();
    int GetUDPSocket();
    const struct timeval *GetTimeout();
    void SetTimeout(struct timeval *);
    TMyBuffer *GetInBuffer();
    TMyBuffer *GetOutBuffer();
    TIP *GetIP();
    const Time *GetLastByteSendOKTime();
    const Time *GetLastByteRecvOKTime();
    int SetNonBlockTCP();
    int SetNonBlockUDP();
    int SetNonBlock(int);
    int SetBufSizeTCP(uint32_t);
    int SetBufSizeUDP(uint32_t);
    int SetBufSize(uint32_t, int);
    int CreateUDP();
    int ListenUDP();
    ssize_t SendUDP();
    std::unique_ptr<TNet>RecvUDP();
    void RecvUDP(TNet *);
    int ListenTCP();
    int ConnectTCP(bool = false);
    int PollTCPSocket();
    int TCPSocketError();
    std::unique_ptr<TNet>AcceptTCP();
    ssize_t SendTCP();
    int RecvTCP();

private:
    struct timeval Timeout = {0, 500000}; // connect timeout wait {sec, usec}
    int SocketTCP = -1;
    int SocketUDP = -1;
    bool SocketOwner = true;
    TMyBuffer IBuf;
    TMyBuffer OBuf;
    TIP IP;
    Time LastByteSendOKTime; // = 0 ?
    Time LastByteRecvOKTime; // = 0 ?
};

#endif
