#pragma once

#ifndef _CLASSPCAP_H_
#define _CLASSPCAP_H_

#include <vector>
#include <unordered_map>
#include <contrib/libs/libpcap/pcap.h>

#include "classip.h"

#define OPTIMIZE_CODE 1
#define SNAPLEN 65535
#define BUFCAPLEN 262144
#define TIMEOUTMS 1
#define LINKTYPE_ETHERNET 1
#define LINKTYPE_LINUX_SLL 113

class TPcap {
public:
    struct IFace {
        bool isLoopback;
        std::vector<TIP> AddressVector;
    };
public:

    TPcap();
    ~TPcap();
    int CheckIface(std::string);
    void Init(std::string, std::string, int);
    void SetNonBlock();
    int GetFileDescriptor();
    void Loop(pcap_handler, u_char * = nullptr);
    void BreakLoop();
    int GetPacket(struct pcap_pkthdr **, const u_char **);
    void LogStats();
    void IfaceCout();
    int GetIfaceLinkType();
private:
    char errbuf[PCAP_ERRBUF_SIZE] = {0};
    std::unordered_map<std::string, IFace> IFaceMap;
    int IfaceLinkType;
    int SelectableFD = 0;
    int MaxPackets = -1;
    int PacketCounter = 0;
    pcap_if_t *alldevs;
    pcap_t *CaptureHandle = nullptr;
    struct bpf_program bpfp = {0, nullptr};
};

#endif
