#include "tcpstream.h"


TTCPStream::TTCPStream() {
}

TTCPStream::TTCPStream(struct in6_addr *SrcIP, uint16_t SrcPort, struct in6_addr *DstIP, uint16_t DstPort) {
    Construct6(SrcIP, SrcPort, DstIP, DstPort);
}

void TTCPStream::Construct6(struct in6_addr *SrcIP, uint16_t SrcPort, struct in6_addr *DstIP, uint16_t DstPort) {
    Src.ConstructFromAddr6Port((uint8_t *)SrcIP, SrcPort);
    Dst.ConstructFromAddr6Port((uint8_t *)DstIP, DstPort);
}

TTCPStream::TTCPStream(struct in_addr *SrcIP, uint16_t SrcPort, struct in_addr *DstIP, uint16_t DstPort) {
    Construct(SrcIP, SrcPort, DstIP, DstPort);
}

void TTCPStream::Construct(struct in_addr *SrcIP, uint16_t SrcPort, struct in_addr *DstIP, uint16_t DstPort) {
    Src.ConstructFromAddrPort(*(uint32_t *)SrcIP, SrcPort);
    Dst.ConstructFromAddrPort(*(uint32_t *)DstIP, DstPort);
}

TTCPStream::~TTCPStream() {
}

const TIP *TTCPStream::GetSrc() const {
    return &Src;
}

const TIP *TTCPStream::GetDst() const {
    return &Dst;
}

bool operator<(const TTCPStream& a, const TTCPStream& b) {
    if (a.Src == b.Src)
        return a.Dst < b.Dst;
    return a.Src < b.Src;
}

bool operator==(const TTCPStream& a, const TTCPStream& b) {
    return a.Src == b.Src && a.Dst == b.Dst;
}
