#pragma once

#ifndef _TCPSTREAM_H_
#define _TCPSTREAM_H_

#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>

#include "classip.h"

class TTCPStream {
public:
    TTCPStream();
    TTCPStream(struct in6_addr *, uint16_t, struct in6_addr *, uint16_t);
    TTCPStream(struct in_addr *, uint16_t, struct in_addr *, uint16_t);
    ~TTCPStream();
    void Construct6(struct in6_addr *, uint16_t, struct in6_addr *, uint16_t);
    void Construct(struct in_addr *, uint16_t, struct in_addr *, uint16_t);
    const TIP *GetSrc() const;
    const TIP *GetDst() const;
    friend bool operator<(const TTCPStream &, const TTCPStream &);
    friend bool operator==(const TTCPStream &, const TTCPStream &);
private:
    TIP Src;
    TIP Dst;
};
namespace std {
    template <>
    struct hash<TTCPStream> {
        std::size_t operator()(const TTCPStream& a) const {
            return a.GetSrc()->hash() + a.GetDst()->hash();
        }
    };
}

#endif
