import asyncio
import logging
import os
import time

from aiohttp import web

from telethon import TelegramClient, events
from telethon.sessions import StringSession

from library.python.monlib.metric_registry import MetricRegistry
from library.python.monlib.encoder import dumps


SOLOMON_MONITORING_BOT_ID = 669213712
CHAT_ID = -1001750942682  # Solomon Telegram e2e


logging.basicConfig(level=logging.INFO)

registry = MetricRegistry()
started = time.time()
uptime = registry.gauge({'sensor': 'uptime_millis'})
alive = True


@events.register(events.NewMessage(chats=(CHAT_ID,)))
async def handle_new_message(event):
    if (event.from_id.user_id == SOLOMON_MONITORING_BOT_ID):
        logging.debug('Event: %s', event)
        registry.gauge({'sensor': 'last_message_at'}).set(event.date.timestamp())


async def run_client(client):
    await client.start()
    await client.run_until_disconnected()


async def get_metrics(request):
    uptime.set((time.time() - started) * 1000)
    return web.Response(body=dumps(registry), content_type='application/x-solomon-spack')


async def get_alive(request):
    return web.Response(body='OK' if alive else 'DEAD')


async def run_server(app):
    runner = web.AppRunner(app)
    await runner.setup()
    site = web.TCPSite(runner)
    await site.start()


def custom_exception_handler(loop, context):
    global alive
    try:
        exception = context.get('exception')
        logging.error(exception)
    except:
        pass
    alive = False


def main():
    API_ID = int(os.environ['API_ID'])
    API_HASH = os.environ['API_HASH']
    DC = os.environ['DEPLOY_NODE_DC']
    SESSION = os.environ[f'SESSION_{DC}']
    client = TelegramClient(StringSession(SESSION), API_ID, API_HASH, use_ipv6=True)
    client.add_event_handler(handle_new_message)
    loop = asyncio.get_event_loop()
    loop.set_exception_handler(custom_exception_handler)
    loop.create_task(run_client(client))
    app = web.Application()
    app.add_routes([web.get('/metrics', get_metrics), web.get('/alive', get_alive)])
    loop.create_task(run_server(app))
    loop.run_forever()
