import argparse
import subprocess
import tarfile
import tempfile
import os
import sys
import shutil
import errno


parser = argparse.ArgumentParser()
parser.add_argument("--node-bin")
parser.add_argument("--node-modules")
parser.add_argument("--source-dir")
parser.add_argument("--output")
parser.add_argument("cmd_args", nargs="+")
args = parser.parse_args()

# (0) prepare links to sources
tmpdir = tempfile.gettempdir()
path = os.path.join(tmpdir, "solomon", "web")
os.makedirs(path)
os.chdir(path)

for path in ["src", "public", "package.json"]:
    if os.path.exists(path):
        continue
    src = os.path.join(args.source_dir, path)
    try:
        shutil.copytree(src, path)
    except OSError as exc:
        if exc.errno == errno.ENOTDIR:
            shutil.copy(src, path)
        else: raise

# (1) unpack node_modules
with tarfile.open(args.node_modules, "r:gz") as tar:
    tar.extractall()

# (2) add path to node into PATH environement variable and call node
os.environ["PATH"] = ":".join([os.path.dirname(args.node_bin), os.getenv("PATH", "")])
subprocess.check_call([args.node_bin] + args.cmd_args, stdout=sys.stderr, stderr=sys.stderr)

# (3) pack build artefacts
with tarfile.open(args.output, "w:gz") as tar:
    tar.add("build", "admin")
