import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';

import Root from './root/Root';
import UnavailableServicePage from './pages/unavailableService/UnavailableServicePage';
import AuthenticationErrorPage from './pages/AuthenticationErrorPage';
import { loadUserInfo } from './store/reducers/others/userInfo';

class App extends PureComponent {
  componentDidMount() {
    this.props.loadUserInfo();
  }

  render() {
    const { userInfo, userSettings } = this.props;

    if (userInfo.error) {
      if (userInfo.error instanceof Object && userInfo.error.code === 401) {
        return <AuthenticationErrorPage tryToReload={userInfo.loading} />;
      }
      return <UnavailableServicePage tryToReload={userInfo.loading} />;
    }

    if (userInfo.data && userSettings.data) {
      return <Root />;
    }

    if (userInfo.loading || userSettings.loading) {
      return (
        <h3 style={{ padding: '20px' }}>
          Loading...
        </h3>
      );
    }

    return null;
  }
}

App.propTypes = {
  userInfo: PropTypes.object.isRequired,
  userSettings: PropTypes.object.isRequired,
  loadUserInfo: PropTypes.func.isRequired,
};

const mapStateToProps = (state) => ({
  userInfo: state.userInfo,
  userSettings: state.userSettings,
});

const mapDispatchToProps = (dispatch) => bindActionCreators({ loadUserInfo }, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(App);
