import * as http from './http';

export function fetchAlerts(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts`, urlParams);
}

export function fetchAlert(projectId, alertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}`);
}

export function fetchAlertInterpolated(projectId, alertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/interpolated`);
}

export function fetchAlertEvalState(projectId, alertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/state/evaluation`);
}

export function fetchAlertEvalStats(projectId, alertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/state/evaluationStats`);
}

export function fetchAlertNotificationState(projectId, alertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/state/notification`);
}

export function fetchAlertNotificationStats(projectId, alertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/state/notificationStats`);
}

export function fetchSubAlerts(projectId, alertId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/subAlerts`, urlParams);
}

export function fetchSubAlert(projectId, alertId, subAlertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/subAlerts/${subAlertId}`);
}

export function fetchSubAlertEvaluationState(projectId, alertId, subAlertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/subAlerts/${subAlertId}/state/evaluation`);
}

export function fetchSubAlertNotificationState(projectId, alertId, subAlertId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/subAlerts/${subAlertId}/state/notification`);
}

export function fetchProjectAlertStats(projectId) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/stats`);
}

export function createAlert(projectId, alert) {
  return http.sendPost(`/api/v2/projects/${projectId}/alerts`, alert);
}

export function createTemplateAlerts(projectId, request) {
  return http.sendPost(`/api/internal/projects/${projectId}/alerts`, request);
}

export function updateAlert(projectId, alert) {
  return http.sendPut(`/api/v2/projects/${projectId}/alerts/${alert.id}`, alert);
}

export function deleteAlert(projectId, alertId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/alerts/${alertId}`);
}

export function explainAlert(projectId, alert) {
  return http.sendPost(`/api/v2/projects/${projectId}/alerts/explainEvaluation`, alert);
}

export function fetchExistingAlertExplanation(projectId, alertId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/explainEvaluation`, urlParams);
}

export function fetchExistingSubAlertExplanation(projectId, alertId, subAlertId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/alerts/${alertId}/subAlerts/${subAlertId}/explainEvaluation`, urlParams);
}

export function fetchAlertTemplates(urlParams) {
  return http.sendGet('/api/v2/alertTemplates', urlParams);
}

export function fetchAlertTemplate(templateId, templateVersionTag) {
  return http.sendGet(`/api/v2/alertTemplates/${templateId}/versions/${templateVersionTag}`);
}

export function fetchAlertTemplateLast(templateId) {
  return http.sendGet(`/api/v2/alertTemplates/${templateId}`);
}
