import * as http from './http';

export function fetchChannels(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/notificationChannels`, urlParams);
}

export function fetchChannel(projectId, channelId) {
  return http.sendGet(`/api/v2/projects/${projectId}/notificationChannels/${channelId}`);
}

export function createChannel(projectId, channel) {
  return http.sendPost(`/api/v2/projects/${projectId}/notificationChannels`, channel);
}

export function updateChannel(projectId, channel) {
  return http.sendPut(`/api/v2/projects/${projectId}/notificationChannels/${channel.id}`, channel);
}

export function deleteChannel(projectId, channelId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/notificationChannels/${channelId}`);
}
