import * as http from './http';

export function fetchGlobalClusters(urlParams) {
  return http.sendGet('/api/internal/clusters', urlParams);
}

export function fetchProjectClusters(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/clusters`, urlParams);
}

export function fetchCluster(projectId, clusterId) {
  return http.sendGet(`/api/v2/projects/${projectId}/clusters/${clusterId}`);
}

export function resolveCluster(cluster) {
  return http.sendPost('/api/internal/fetcher/resolveCluster', cluster);
}

export function createCluster(projectId, cluster) {
  return http.sendPost(`/api/v2/projects/${projectId}/clusters`, cluster);
}

export function updateCluster(projectId, cluster) {
  return http.sendPut(`/api/v2/projects/${projectId}/clusters/${cluster.id}`, cluster);
}

export function deleteCluster(projectId, clusterId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/clusters/${clusterId}`);
}

export function fetchClusterServices(projectId, clusterId) {
  return http.sendGet(`/api/v2/projects/${projectId}/clusters/${clusterId}/services`);
}
