import * as http from './http';

export function fetchAllDashboards(urlParams) {
  return http.sendGet('/api/internal/dashboards', urlParams);
}

export function fetchProjectDashboards(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/dashboards`, urlParams);
}

export function fetchDashboard(projectId, dashboardId) {
  return http.sendGet(`/api/v2/projects/${projectId}/dashboards/${dashboardId}`);
}

export function createDashboard(projectId, dashboard) {
  return http.sendPost(`/api/v2/projects/${projectId}/dashboards`, dashboard);
}

export function updateDashboard(projectId, dashboard) {
  return http.sendPut(`/api/v2/projects/${projectId}/dashboards/${dashboard.id}`, dashboard);
}

export function deleteDashboard(projectId, dashboardId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/dashboards/${dashboardId}`);
}
