import { formatISO8601 } from '../../utils/iso8601';
import { formatDuration, parseDuration } from '../../utils/duration';

function createDurationButton(nextDuration, fromMillis, toMillis, durationMillis, isNow) {
  const nextDurationMillis = parseDuration(nextDuration);
  const selected = durationMillis === nextDurationMillis;

  if (isNow) {
    return {
      begin: nextDuration,
      end: '',
      selected,
    };
  }

  const begin = formatISO8601(fromMillis - nextDurationMillis);
  const end = formatISO8601(fromMillis);
  return { begin, end, selected };
}

function createGggNavButtons(b, e, fromMillis, toMillis) {
  const isNow = !e;

  const durationMillis = Math.abs(toMillis - fromMillis);

  const fastBackwardBegin = formatISO8601(Math.trunc(fromMillis - (durationMillis / 2)));
  const fastBackwardEnd = formatISO8601(Math.trunc(toMillis - (durationMillis / 2)));
  const fastForwardBegin = formatISO8601(Math.trunc(fromMillis + (durationMillis / 2)));
  const fastForwardEnd = formatISO8601(Math.trunc(toMillis + (durationMillis / 2)));

  let zoomInBegin;
  let zoomInEnd;
  let zoomOutBegin;
  let zoomOutEnd;

  if (isNow) {
    zoomInBegin = formatDuration(Math.trunc(durationMillis / 2));
    zoomInEnd = '';
    zoomOutBegin = formatDuration(durationMillis * 2);
    zoomOutEnd = '';
  } else {
    zoomInBegin = formatISO8601(fromMillis + (durationMillis / 4));
    zoomInEnd = formatISO8601(toMillis - (durationMillis / 4));
    zoomOutBegin = formatISO8601(fromMillis - (durationMillis / 4));
    zoomOutEnd = formatISO8601(toMillis + (durationMillis / 4));
  }

  const zoom1h = createDurationButton('1h', fromMillis, toMillis, durationMillis, isNow);
  const zoom1d = createDurationButton('1d', fromMillis, toMillis, durationMillis, isNow);
  const zoom1w = createDurationButton('1w', fromMillis, toMillis, durationMillis, isNow);
  const zoom1m = createDurationButton('31d', fromMillis, toMillis, durationMillis, isNow);
  const zoom1y = createDurationButton('365d', fromMillis, toMillis, durationMillis, isNow);

  return {
    fastBackward: {
      begin: fastBackwardBegin,
      end: fastBackwardEnd,
      selected: false,
    },
    fastForward: {
      begin: fastForwardBegin,
      end: fastForwardEnd,
      selected: false,
    },
    zoomIn: { begin: zoomInBegin, end: zoomInEnd, selected: false },
    zoomOut: { begin: zoomOutBegin, end: zoomOutEnd, selected: false },
    scrollNow: { begin: formatDuration(durationMillis), end: '', selected: isNow },
    zoom1d,
    zoom1h,
    zoom1m,
    zoom1w,
    zoom1y,
  };
}

export default createGggNavButtons;
