function createGggDateTime(millis) {
  return {
    instant: new Date(millis).toISOString(),
    epochSeconds: Math.trunc(millis / 1000),
    epochMillis: millis,
  };
}

function createGggTimeRange(fromMillis, toMillis, nowMillis) {
  return {
    begin: createGggDateTime(fromMillis),
    end: createGggDateTime(toMillis),
    now: createGggDateTime(nowMillis),
  };
}

export default createGggTimeRange;
