import { doubleQuote } from '../../utils/Quoter';

export function formatOldSelectorsAsOldLabels(oldSelectorsAsEntries) {
  return oldSelectorsAsEntries.map((s) => {
    const key = s[0].indexOf('-') >= 0 ? doubleQuote(s[0]) : s[0];
    const value = doubleQuote(s[1]);
    return `${key}=${value}`;
  })
    .join(', ');
}

function createMatchingParamsFromSelectorsAsEntries(project, selectorsAsEntries) {
  const newSelectorsList = [...selectorsAsEntries];
  newSelectorsList.unshift(['project', project]);
  const labels = formatOldSelectorsAsOldLabels(newSelectorsList);
  return { labels };
}

export default createMatchingParamsFromSelectorsAsEntries;
