import UrlUtils from '../../utils/url/UrlUtils';
import UserLinksBasic from '../../utils/UserLinksBasic';

function createEntityOptions(pageUrl, entityType, entityId, entityOpts, pageUrlWithoutEntityParam) {
  if (entityOpts === null) {
    throw new Error('unknown entity opts');
  }

  const options = entityOpts.matchingEntities.map((entity) => {
    const { id, name } = entity;

    const selected = id === entityId;

    const fullPath = `/?${pageUrlWithoutEntityParam}&${entityType}=${id}`;

    return {
      value: name,
      fullPath,
      selected,
    };
  });

  if (!options.some((o) => o.selected)) {
    const firstOption = {
      value: entityOpts.name,
      fullPath: pageUrl,
      selected: true,
    };
    options.unshift(firstOption);
  }
  return options;
}

function createLastEntitySelector(
  isAutoGraph,
  pageUrl,
  entityType,
  entityId,
  entityOpts,
  pageUrlWithoutEntityParam,
) {
  let lastSelectorOptions;

  if (isAutoGraph) {
    lastSelectorOptions = [{
      value: 'Auto',
      fullPath: `/?${pageUrl}`,
      selected: true,
    }];
  } else {
    lastSelectorOptions = createEntityOptions(
      pageUrl,
      entityType,
      entityId,
      entityOpts,
      pageUrlWithoutEntityParam,
    );
  }

  return {
    name: entityType,
    dropPath: `/?${pageUrlWithoutEntityParam}`,
    options: lastSelectorOptions,
    value: null,
    showAllValues: false,
    asyncSelector: false,
  };
}

function createAsyncLabelSelector(
  selector,
  pageUrlWithoutEntityParam,
  selectorsAsEntriesWithDataProjectId,
  isAutoGraph,
) {
  const name = selector[0];
  const value = selector[1];

  const dropPath = UrlUtils.removeQueryArgs(`/?${pageUrlWithoutEntityParam}`, name, `l.${name}`);

  const requestPath = selectorsAsEntriesWithDataProjectId
    .filter((s) => s[0] !== name)
    .map((s) => `${s[0]}=${encodeURIComponent(s[1])}`)
    .join('&');

  const isStaticSelector = name === 'cluster' || name === 'service' || !isAutoGraph;

  const wildcardType = isStaticSelector ? 'NONE' : 'FULL_AND_SIMPLE';

  return ({
    name,
    value,
    asyncSelector: true,
    options: [],
    dropPath,
    requestPath,
    wildcardType,
  });
}

// eslint-disable-next-line max-len
export function createGggSelectors(projectId, dataProjectId, selectorsAsEntries, entityType, entityId, entityOpts = null) {
  const isAutoGraph = entityType === 'graph' && entityId === 'auto';

  const selectorsAsEntriesWithProject = [...selectorsAsEntries];
  selectorsAsEntriesWithProject.unshift(['project', projectId]);

  const selectorsAsEntriesWithDataProject = [...selectorsAsEntries];
  selectorsAsEntriesWithDataProject.unshift(['project', dataProjectId]);

  const pageUrlWithoutEntityParam = selectorsAsEntriesWithProject
    .map((s) => `${UserLinksBasic.labelNameToQueryArgName(s[0])}=${UrlUtils.encodeArg(s[1])}`)
    .join('&');

  const pageUrl = `${pageUrlWithoutEntityParam}&${entityType}=${entityId}`;

  const gggSelectors = selectorsAsEntries
    .map((selector) => createAsyncLabelSelector(
      selector,
      pageUrlWithoutEntityParam,
      selectorsAsEntriesWithDataProject,
      isAutoGraph,
    ));

  const lastSelector = createLastEntitySelector(
    isAutoGraph,
    pageUrl,
    entityType,
    entityId,
    entityOpts,
    pageUrlWithoutEntityParam,
  );

  gggSelectors.push(lastSelector);

  return gggSelectors;
}

export default createGggSelectors;
