import * as http from './http';

export function fetchAllGraphs(urlParams) {
  return http.sendGet('/api/internal/graphs', urlParams);
}

export function fetchProjectGraphs(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/graphs`, urlParams);
}

export function fetchGraph(projectId, graphId) {
  return http.sendGet(`/api/v2/projects/${projectId}/graphs/${graphId}`);
}

export function createGraph(projectId, graph) {
  return http.sendPost(`/api/v2/projects/${projectId}/graphs`, graph);
}

export function updateGraph(projectId, graph) {
  return http.sendPut(`/api/v2/projects/${projectId}/graphs/${graph.id}`, graph);
}

export function deleteGraph(projectId, graphId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/graphs/${graphId}`);
}
