import * as http from './http';
import { formatSearch } from '../utils/url';

const ROLES_PAGE_SIZE = 1000;

export function getPinsByUrl(params) {
  return http.sendPost('/api/internal/pinsByUrl', params);
}

export function getPinByUrl(params) {
  return http.sendPost('/api/internal/pinByUrl', params);
}

export function createPin(params) {
  return http.sendPost('/api/internal/pins', params);
}

export function deletePin(id) {
  return http.sendDelete(`/api/internal/pins/${id}`);
}

export function getMatchingShard(projectId, params) {
  return http.sendPost(`/api/internal/projects/${projectId}/matchingShard`, params);
}

export function getMatchingGraphs(projectId, params) {
  return http.sendPost(`/api/internal/projects/${projectId}/matchingGraphs`, params);
}

export function getMatchingDashboards(projectId, params) {
  return http.sendPost(`/api/internal/projects/${projectId}/matchingDashboards`, params);
}

export function getMatchingMenus(projectId, params) {
  return http.sendPost(`/api/internal/projects/${projectId}/menu`, params);
}

export function reloadShard(projectId, shardId, host, service) {
  const search = formatSearch({ host, service });
  const url = `/api/internal/projects/${projectId}/shards/${shardId}/reload?${search}`;
  return http.sendPost(url, {});
}

export function getUserSettings() {
  return http.sendGet('/api/internal/settings');
}

export function updateUserSettings(settings) {
  return http.sendPut('/api/internal/settings/', settings);
}

export function getRoles() {
  return http.sendGet('/api/internal/roles');
}

export function getFeatureFlags(projectId) {
  return http.sendGet(`/api/internal/feature-flags/${projectId}`);
}

export function getProjectIdmRoles(projectId) {
  return http.sendGet(`/api/internal/${projectId}/roles`, { pageSize: ROLES_PAGE_SIZE });
}

export function updateUserSetting(key, value) {
  return http.sendRequest(`/api/internal/settings/${key}`, {
    method: 'PUT',
    body: value,
    headers: {
      'Content-Type': 'text/plain',
    },
  }, true);
}
