import { formatSearch } from '../utils/url';
import * as http from './http';

export function fetchProjectMutes(projectId, urlParams) {
  return http.sendGet(`/api/v2/projects/${projectId}/mutes`, urlParams);
}

export function fetchMute(projectId, muteId) {
  return http.sendGet(`/api/v2/projects/${projectId}/mutes/${muteId}`);
}

export function createMute(projectId, mute) {
  return http.sendPost(`/api/v2/projects/${projectId}/mutes`, mute);
}

export function updateMute(projectId, mute) {
  return http.sendPut(`/api/v2/projects/${projectId}/mutes/${mute.id}`, mute);
}

export function deleteMute(projectId, muteId) {
  return http.sendDelete(`/api/v2/projects/${projectId}/mutes/${muteId}`);
}

export function fetchProjectMutesStats(projectId) {
  return http.sendGet(`/api/v2/projects/${projectId}/mutes/stats`);
}

export function explainMute(projectId, mute, params) {
  const search = params ? `?${formatSearch(params)}` : '';
  return http.sendPost(`/api/v2/projects/${projectId}/alerts/explainMute${search}`, mute);
}
