import * as http from './http';
import { formatSearch, parseSearch } from '../utils/url';
import FRONTEND_VERSION from '../utils/frontendVersion';
import getSelectorsFromQueryArgs from '../utils/queryArgs';
import { formatOldSelectorEntriesAsNewSelectors } from '../utils/SelectorUtils';
import { fetchLabels } from './sensors';
import addWildcardLinks from '../utils/wildcards/Wildcards';

export function loadGeneric(params) {
  const urlParams = { ...params, countUsage: 'n', solomonClientVersion: FRONTEND_VERSION };
  return http.sendGet('/rest/generic', urlParams);
}

export function loadGraphData(params, formData) {
  return http.sendRequest(`/rest/graph-data?${formatSearch(params)}`, {
    method: 'POST',
    body: formData,
    credentials: 'same-origin',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
    },
  }, true);
}

export function loadSelectorValuesOld(params) {
  return http.sendGet('/rest/selectorValues', params);
}

export function loadSelectorValues(params) {
  const parsedSearch = parseSearch(params.selectors);

  const selectorsFromQueryArgs = getSelectorsFromQueryArgs(parsedSearch, true, true);

  const projectId = parsedSearch.get('project') || '';

  const selectors = formatOldSelectorEntriesAsNewSelectors(selectorsFromQueryArgs, true);

  const name = params.label;

  const urlParams = {
    selectors,
    forceCluster: params.forceCluster || '',
    names: name,
    limit: 100,
  };
  return fetchLabels(projectId, urlParams)
    .then((response) => {
      if (response.labels && response.labels.length > 0) {
        const labelData = response.labels[0];
        let { values } = labelData;
        const { truncated } = labelData;
        if (params.wildcardType !== 'NONE') {
          values = addWildcardLinks(values);
          values.unshift('*');
        }
        if (labelData.absent) {
          values.unshift('-');
        }
        return {
          values,
          truncated,
        };
      }

      return {
        values: [],
        truncated: false,
      };
    });
}
